#include "CApplication.h"

#include <stdlib.h>
#include <time.h>

#define PI 3.1415926535897932384626433832795

#define LOW_MUSIC_VOLM 0.4f
#define HIGH_MUSIC_VOLM 1.0f

//char *musicFin[1]={".\\Media\\Music\\Remixes - Star Fox Techno.ogg"};
char *musicFin[1]={".\\Media\\Music\\scottaltham_-_I_Wonder_If_God_Was_Sleeping_(Transcendence_Edit).ogg"};

// ====================== Inline random ==========================

//initialisation du gnrateur de nbres aleatoires
inline void randomize(){
  srand((time_t) time(NULL));                           
}
//gnrateur de nbres alatoires entre 0 et n-1
inline int random(int n){
  return rand()%n;
}

// ===============================================================


// ======================== Music Data ===========================

#define NBZIK 3
char *listMusic[NBZIK]=
{
    //".\\Media\\Music\\StarFox - 06 - Corneria.ogg",
    //".\\Media\\Music\\Starfox 64 - Space Armada.ogg"
    ".\\Media\\Music\\6_azoora_motionless.ogg",
    ".\\Media\\Music\\1_tryad_struttin.ogg",
    //".\\Media\\Music\\Epoq-Lepidoptera.ogg",
    ".\\Media\\Music\\freestylemix_-_hisboyelroy_-_Revolve.ogg"
};

// ===============================================================



// ======================== Light base ===========================

GLfloat spec[4]={0.5,0.5,0.5,1.0};
GLfloat diff[4]={0.8,0.8,0.8,1.0};
GLfloat amb[4]={0.01,0.01,0.01,1.0};

// ===============================================================


// ======================== Material base ===========================

GLfloat matBaseSpec[4]={0.6,0.6,1.1,1.0};
GLfloat matBaseDiff[4]={0.8,0.8,1.1,1.0};
GLfloat matBaseAmb[4]={0.0,0.0,1.0,1.0};
GLfloat matBaseEmi[4]={0.0,0.0,0.0,1.0};
GLfloat matBaseShiness=0.0;

// ==================================================================


CApplication *CApplication::selfPointer=NULL;


void CApplication::frameMove()
{
 if(cMant.mAct)cMant.centerMouse(); //centrer la souris
    
 int elapsedTime;
 if(pause) // si en pause
 {
  int timeIs=glutGet(GLUT_ELAPSED_TIME);
  elapsedTime=timeIs-oldTime;
  if(elapsedTime<40)
  {
        Sleep(40-elapsedTime);
        timeIs=glutGet(GLUT_ELAPSED_TIME);
        elapsedTime=timeIs-oldTime;
    }
  oldTime=timeIs;
  return; // on n'avance pas le jeu
 }
 else
 {
  int timeIs=glutGet(GLUT_ELAPSED_TIME);
  elapsedTime=timeIs-oldTime;
  if(elapsedTime<28)// si le CPU  de la marge
  {
        Sleep(28-elapsedTime); // on le laisse souffler
        timeIs=glutGet(GLUT_ELAPSED_TIME);
        elapsedTime=timeIs-oldTime;
    }
  oldTime=timeIs;
 }
 
 
 mdp.frameMoveThread(elapsedTime); // lancement de la MAJ des particules sur thread
  
  //======FRAME MOVE BEGIN======
  
    if(jr.ressusiter(elapsedTime))
    {
        o_music.stopMusic();
        mCld.clear();
        mdp.clearParts();
        mCld.addCollide(&jr);
        Vecteur *ptrP,*ptrV;
        jr.getPtrCible(ptrP,ptrV);
        CItEnnemi::setCiblePosVel(ptrP,ptrV);
        //progression=500.0;
        //stg=START;
        if(stg<FINISH1)
        {
            o_music.setVolume(LOW_MUSIC_VOLM);
            o_music.launchMusicListID(NBZIK,listMusic,id,true);
            if(stg!=START)stg=(EStage)(((int)stg)-1);
        }
        else
        {
            //o_music.launchMusicList(1,&musicFin,true);
            /*
            pthread_t musicThrd;
            pthread_create(&musicThrd,NULL,musicThrdFin,NULL);
            */
            o_music.stopMusic();
            o_music.setVolume(HIGH_MUSIC_VOLM);
            o_music.launchMusicListID(1,musicFin,0,true);
        }
        //stg=FIGHTAREA9Bis;
        progression=2000.0;
        oldTime=glutGet(GLUT_ELAPSED_TIME);
    }
  
  //mdp.frameMove(elapsedTime);
  mCld.frameMove(elapsedTime);
  px=jr.getMvmnt();
  trSplt.frameMove(px);
  
    // On applique la progression  la gestion des vnements du jeu
    ennemisPX-=px;
    progression-=px;
    
    if(ennemisPX<=0.0 || progression<=0.0) // si il est temps de changer quelque chose
    {
        unsigned short int rnd=rand()%1000;
        unsigned char modeTir=(unsigned char)(rand());
        
        //stg=TRAINNING1;
        switch(stg)//switch sur els tapes du jeu
        {
            case START:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=4000.0;}
                /*else // sinon add bestio
                {
                    
                }*/
                break;
            case TRAINNING1:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=6000.0;}
                else // sinon add bestio
                {
                    ennemisPX=600+rand()%700;
                    addEnnemiFIXTrr(0.04,100.0,LASERBLEU_BIG+rand()%5,400,10);
                }
                break;
            case TRAINNING2:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=6000.0;}
                else // sinon add bestio
                {
                    ennemisPX=500+rand()%500;
                    if(rnd<400)addEnnemiFIXTrr(0.04,120.0,LASERBLEU_BIG+rand()%5,360,10);
                    else addEnnemiFIXLau(0.04,100.0,MISSILE1,400,30);
                }
                break;
            case FIGHTAREA1:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=13000.0;}
                else // sinon add bestio
                {
                    ennemisPX=400+rand()%400;
                    if(rnd<300)addEnnemiFIXTrr(0.03,150.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<600)addEnnemiFIXLau(0.03,150.0,MISSILE1+rand()%5,400,30);
                    else addEnnemiVOLShip7(0.03,180.0,modeTir%5,LASERBLEU+rand()%5,380,15);
                }
                break;
            case FIGHTAREA2:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=12000.0;}
                else // sinon add bestio
                {
                    ennemisPX=400+rand()%400;
                    if(rnd<200)addEnnemiFIXTrr(0.02,150.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<400)addEnnemiFIXLau(0.02,150.0,MISSILE1+rand()%5,400,30);
                    else if(rnd<700)addEnnemiVOLShip7(0.01,180.0,modeTir%5,LASERBLEU+rand()%5,280,20);
                    else addEnnemiVOLShip6(0.01,180.0,modeTir%5,LASERBLEU+rand()%5,380,20);
                }
                break;
            case FIGHTAREA3:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=13000.0;}
                else // sinon add bestio
                {
                    ennemisPX=200+rand()%500;
                    if(rnd<100)addEnnemiFIXTrr(0.007,150.0,LASERBLEU_BIG+rand()%5,400,15);
                    else if(rnd<200)addEnnemiFIXLau(0.01,150.0,MISSILE1+rand()%5,400,40);
                    else if(rnd<400)addEnnemiVOLShip7(0.005,180.0,modeTir%5,LASERBLEU+rand()%5,280,30);
                    else if(rnd<850)addEnnemiVOLShip6(0.008,180.0,modeTir%5,LASERBLEU+rand()%5,380,25);
                    else addEnnemiVOLShip2(0.004,140.0,modeTir%5,LASERBLEU+rand()%5,350,15);
                }
                break;
            case FIGHTAREA4:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=5000.0;}
                else // sinon add bestio
                {
                    ennemisPX=120+rand()%450;
                    if(rnd<90)addEnnemiFIXTrr(0.01,150.0,LASERBLEU_BIG+rand()%5,400,12);
                    else if(rnd<180)addEnnemiFIXLau(0.01,150.0,MISSILE1+rand()%5,400,33);
                    else if(rnd<600)addEnnemiVOLShip7(0.009,180.0,modeTir%5,LASERBLEU+rand()%5,280,40);
                    else if(rnd<800)addEnnemiVOLShip6(0.01,180.0,modeTir%5,LASERBLEU+rand()%5,380,20);
                    else if(rnd<940)addEnnemiVOLShip2(0.002,140.0,modeTir%5,LASERBLEU+rand()%5,350,15);
                    else addEnnemiVOLShip4(0.001,200.0,modeTir%5,MISSILE1+rand()%5,600,20);
                }
                break;
            case FIGHTAREA5:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=1500.0;}
                else // sinon add bestio
                {
                    ennemisPX=600+rand()%600;
                    if(rnd<90)addEnnemiFIXTrr(0.04,100.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<180)addEnnemiFIXLau(0.04,100.0,MISSILE1+rand()%5,400,10);
                    else if(rnd<600)addEnnemiVOLShip7(0.04,100.0,modeTir%5,LASERBLEU+rand()%5,280,10);
                    else addEnnemiVOLShip6(0.04,100.0,modeTir%5,LASERBLEU+rand()%5,380,10);
                }
                break;
            case FIGHTAREA5Bis:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=20000.0;}
                else // sinon add bestio
                {
                    ennemisPX=8+rand()%20;
                    addEnnemiFIXTrr(0.03,100.0,LASERBLEU_BIG+rand()%5,400,10);
                }
                break;
            case FIGHTAREA6:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=15000.0;}
                else // sinon add bestio
                {
                    ennemisPX=350+rand()%300;
                    if(rnd<90)addEnnemiFIXTrr(0.01,150.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<180)addEnnemiFIXLau(0.01,150.0,MISSILE1+rand()%5,400,30);
                    else if(rnd<600)addEnnemiVOLShip8(0.001,180.0,modeTir%5,LASERBLEU+rand()%5,280,28);
                    else if(rnd<800)addEnnemiVOLShip6(0.003,180.0,modeTir%5,LASERBLEU+rand()%5,380,30);
                    else if(rnd<910)addEnnemiVOLShip5(0.002,140.0,modeTir%5,LASERBLEU+rand()%5,350,15);
                    else addEnnemiVOLShip3(0.001,210.0,2*(modeTir%3),MISSILE1+rand()%5,600,25);
                }
                break;
            case FIGHTAREA7:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=13000.0;}
                else // sinon add bestio
                {
                    modeTir%=5;
                    ennemisPX=250+rand()%400;
                    if(rnd<90)addEnnemiFIXTrr(0.001,150.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<190)addEnnemiFIXLau(0.001,150.0,MISSILE1+rand()%5,400,20);
                    else if(rnd<600)addEnnemiVOLShip7(0.02,180.0,modeTir,LASERBLEU+rand()%5,280,25);
                    else if(rnd<800)addEnnemiVOLShip6(0.01,180.0,modeTir,LASERBLEU+rand()%5,370,25);
                    else if(rnd<940)addEnnemiVOLShip5(0.001,120.0,modeTir,LASERBLEU+rand()%5,250,8);
                    else addEnnemiVOLShip9(0.001,200.0,modeTir,MISSILE1+rand()%5,400*getMult(modeTir),20);
                }
                break;
            case FIGHTAREA8:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=4000.0;}
                else // sinon add bestio
                {
                    ennemisPX=350+rand()%350;
                    if(rnd<200)addEnnemiFIXTrr(0.001,90.0,LASERBLEU_BIG+rand()%5,200,8);
                    else if(rnd<400)addEnnemiFIXLau(0.001,110.0,MISSILE1+rand()%5,250,25);
                    else if(rnd<600)addEnnemiVOLShip2(0.002,180.0,modeTir%5,LASERBLEU+rand()%5,280,24);
                    else if(rnd<820)addEnnemiVOLShip6(0.0017,180.0,modeTir%5,LASERBLEU+rand()%5,360,22);
                    else if(rnd<910)addEnnemiVOLShip5(0.0018,140.0,modeTir%5,LASERBLEU+rand()%5,350,17);
                    else addEnnemiVOLShip7(0.001,164.0,1+2*(modeTir%2),LASERBLEU+rand()%5,500,30);
                }
                break;
            case FIGHTAREA9:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=1500.0;}
                else // sinon add bestio
                {
                    ennemisPX=600+rand()%600;
                    if(rnd<90)addEnnemiFIXTrr(0.04,100.0,LASERBLEU_BIG+rand()%5,400,10);
                    else if(rnd<180)addEnnemiFIXLau(0.04,100.0,MISSILE1+rand()%5,400,10);
                    else if(rnd<600)addEnnemiVOLShip7(0.04,100.0,modeTir%5,LASERBLEU+rand()%5,280,10);
                    else addEnnemiVOLShip6(0.04,100.0,modeTir%5,LASERBLEU+rand()%5,380,10);
                }
                break;
            case FIGHTAREA9Bis:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=20000.0;}
                else // sinon add bestio
                {
                    ennemisPX=8+rand()%20;
                    if(rnd<500)addEnnemiFIXTrr(0.01,100.0,LASERBLEU_BIG+rand()%5,400,10);
                    else addEnnemiFIXLau(0.01,100.0,MISSILE1+rand()%5,400,20);
                }
                break;
            case FIGHTAREAF:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=1000.0;}
                else // sinon add bestio
                {
                    modeTir%=5;
                    ennemisPX=200+rand()%400;
                    if(rnd<100)addEnnemiFIXTrr(0.001,90.0,LASERBLEU_BIG+rand()%5,200,8);
                    else if(rnd<200)addEnnemiFIXLau(0.001,110.0,MISSILE1+rand()%5,200,20);
                    else if(rnd<260)addEnnemiVOLShip2(0.001,190.0,modeTir,LASERBLEU+rand()%5,235,17);
                    else if(rnd<320)addEnnemiVOLShip3(0.001,175.0,modeTir,MISSILE1+rand()%5,400,18);
                    else if(rnd<380)addEnnemiVOLShip4(0.001,180.0,modeTir,LASERBLEU+rand()%5,210,16);
                    else if(rnd<440)addEnnemiVOLShip5(0.001,180.0,modeTir,LASERBLEU+rand()%5,200,19);
                    else if(rnd<580)addEnnemiVOLShip6(0.001,140.0,modeTir,MISSILE1+rand()%5,450,15);
                    else if(rnd<720)addEnnemiVOLShip7(0.001,130.0,modeTir,LASERBLEU+rand()%5,204,16);
                    else if(rnd<860)addEnnemiVOLShip8(0.001,145.0,modeTir,LASERBLEU+rand()%5,230,16);
                    else addEnnemiVOLShip9(0.001,164.0,modeTir,MISSILE1+rand()%5,500,23);
                }
                break;
            case FINISH1:
                if(progression<=0.0){stg=(EStage)(((int)stg)+1);ennemisPX=0.0;progression=100.0;}
                break;
            case FINISH2:
                stg=(EStage)(((int)stg)+1);
                
                o_music.stopMusic();
                o_music.setVolume(HIGH_MUSIC_VOLM);
                o_music.launchMusicListID(1,musicFin,0,true);
                /*
                pthread_t musicThrd;
                pthread_create(&musicThrd,NULL,musicThrdFin,NULL);
                */
                //o_music.launchMusicList(1,&musicFin,true);
                
                break;
        };
        
        
        srand((time_t) rand());
    }
    
    mdp.frameMoveJoin(); // joindre le thread des particules et appliquer les commandes de particules.
  
  //=======FRAME MOVE END=======
  glutPostRedisplay(); // demander un affichage
}


//Retourne le nombre de laser tirs suivant un mode de tire.
unsigned char CApplication::getMult(unsigned char mode)
{
    if(mode & 0x01)
    {
        if(mode==1)return 2;
        else return 3;
    }
    
    return 1;
}

unsigned char CApplication::getIdProj(unsigned char modeTir,unsigned char project)
{
    if(project>=LASERBLEU)project-=LASERBLEU;
    else project+=10-MISSILE1;
    
    return ((modeTir<<5)|project);
}

//Ajout d'un nemis
void CApplication::addEnnemiVOLShip2(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP2,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(70.0/(16.0*4))*SCL_SHIP2,0.375*SCL_SHIP2,0.5,0.995));
}
void CApplication::addEnnemiVOLShip3(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP2,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(45.0/(16.0*4))*SCL_SHIP3,0.375*SCL_SHIP3,0.5,0.995));
}
void CApplication::addEnnemiVOLShip4(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP4,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(60.0/(16.0*4))*SCL_SHIP4,0.375*SCL_SHIP4,0.5,0.995));
}
void CApplication::addEnnemiVOLShip5(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP5,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(85.0/(16.0*4))*SCL_SHIP5,0.375*SCL_SHIP5,0.5,0.995));
}
void CApplication::addEnnemiVOLShip6(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP6,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(74.0/(16.0*4))*SCL_SHIP6,0.375*SCL_SHIP6,0.5,0.995));
}
void CApplication::addEnnemiVOLShip7(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP7,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(52.0/(16.0*4))*SCL_SHIP7,0.375*SCL_SHIP7,0.5,0.995));
}
void CApplication::addEnnemiVOLShip8(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP8,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(76.0/(16.0*4))*SCL_SHIP8,0.375*SCL_SHIP8,0.5,0.995));
}
void CApplication::addEnnemiVOLShip9(float precision,float shield,unsigned char modeTir,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    mCld.addCollide(new CEnnemiVolant(shield,getIdProj(modeTir,project),dmgShot,timeShoot,SHIP9,precision,800-rand()%1600,200.0+rand()%300,9000.0+px,0.0,0.0,0.0,0.0,0.0,0.0,(80.0/(16.0*4))*SCL_SHIP9,0.375*SCL_SHIP9,0.5,0.995));
}

void CApplication::addEnnemiFIXLau(float precision,float shield,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    
    float rx=800-rand()%1600;//,rz=1950.0,tt;
    /*
    tt=trSplt.getLimitTest(rx,rz);
    if(tt>46.0)rz=1900.0;
    else if(tt<4.0)rz=2000.0;
    */
    mCld.addCollide(new CEnnemiFixSol(shield,project,dmgShot,timeShoot,LAUNCHER1_B,LAUNCHER1_N,LAUNCHER1_H,LAUNCHER1_HB,0.0,2*PI,0.006,rx,trSplt.getHeight(rx,9000.0)+80.0*SCL_LAUNCHER1,9000.0+px,160.0*SCL_LAUNCHER1,0.5));
}
void CApplication::addEnnemiFIXTrr(float precision,float shield,unsigned char project,unsigned short timeShoot,unsigned char dmgShot)
{
    float rx=800-rand()%1600;//,rz=1950.0,tt;
    /*
    tt=trSplt.getLimitTest(rx,rz);
    if(tt>46.0)rz=1900.0;
    else if(tt<4.0)rz=2000.0;
    */
    mCld.addCollide(new CEnnemiFixSol2(shield,project,dmgShot,timeShoot,TURRET1_B,TURRET1_N,TURRET1_H,TURRET1_HB,0.0,2*PI,0.001,rx,trSplt.getHeight(rx,9000.0)+80.0*SCL_TURRET1,9000.0+px,90.0*SCL_TURRET1,0.5));
}



void CApplication::render()
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);// | GL_ACCUM_BUFFER_BIT);
 
  //======RENDER BEGIN======
  
  //Reinit mat base
  glMaterialfv (GL_FRONT_AND_BACK,GL_AMBIENT,matBaseSpec);
  glMaterialfv (GL_FRONT_AND_BACK,GL_DIFFUSE,matBaseDiff);
  glMaterialfv (GL_FRONT_AND_BACK,GL_SPECULAR,matBaseAmb);
  glMaterialfv (GL_FRONT_AND_BACK,GL_EMISSION,matBaseEmi);
  glMaterialfv (GL_FRONT_AND_BACK,GL_SHININESS,&matBaseShiness);
  
  glLoadIdentity();
  jr.fixCam();
  
  //Draw sky box
  glDisable(GL_LIGHTING);
  glPushMatrix();
  jr.translateCam();
  glDisable(GL_FOG);
  cCbox.render();
  glEnable(GL_FOG);
  glPopMatrix();
  glEnable(GL_LIGHTING);
  
  glClear(GL_DEPTH_BUFFER_BIT);
  
  //Draw objects
  trSplt.render();
  mCld.render(px);
  mCld.renderTransparent(px);
  mdp.render(px);
  
  jr.rendCross();
  
  px=0.0;
  //=======RENDER END=======
  
  glFlush();
  glutSwapBuffers();
}

void CApplication::clearApp()
{
    if(selfPointer==this)
    {
        selfPointer=NULL;
        CTexture::Kill();
        o_music.stopMusic();
        //cMant.clearManette();
        //CMusic::ShutdownOpenAL();
        alutExit();
    }
}








//===========================Public================================
//===========================Public================================
//===========================Public================================

CApplication::CApplication()
{
 if(!selfPointer)
 {
  selfPointer=this;
 }
 pause=false;
}


CApplication::~CApplication(){clearApp();}


void CApplication::initWindows(int argc,char *argv[],char *wName,int w,int h,bool fullscreen)
{
 if(selfPointer!=this)return;
 
 //CMusic::InitOpenAL();
 alutInit(&argc,argv);
 
 glutInit(&argc,argv);
 glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);// | GLUT_ACCUM);
 glutInitWindowSize(w,h);
 this->w=w;this->h=h;
 glutInitWindowPosition((1024-w)>>1,(768-h)>>1);
 glutCreateWindow(wName);
 
 glutReshapeFunc(recharge);
 
 glutDisplayFunc(display);
 glutIdleFunc(frame);
 
 glutPassiveMotionFunc(mouseMove);
 glutMotionFunc(mouseMove);
 glutMouseFunc(mouse);
 glutKeyboardFunc(keybDown);
 glutKeyboardUpFunc(keybUp);
 glutSpecialFunc(specDown);
 glutSpecialUpFunc(specUp);
 glutMouseWheelFunc(mouseWheel);
 
 //glutCloseFunc(closeFunc);
 //glutWMCloseFunc(closeFunc);
 glutSetOption(GLUT_ACTION_ON_WINDOW_CLOSE,GLUT_ACTION_GLUTMAINLOOP_RETURNS);
}

void CApplication::initScene()
{
 if(selfPointer!=this)return;
 randomize();
 //srand(glutGet(GLUT_ELAPSED_TIME));
 
 //======== Init OpenGL Base =========
 glClearColor(0.0,0.5,1.0,1.0);
 glColor3f(1.0,1.0,1.0);
 
 recharge(w,h);
 
 glCullFace(GL_BACK);
 glEnable(GL_CULL_FACE);
 
 glDepthFunc(GL_LESS);
 glEnable(GL_DEPTH_TEST);
 
 glShadeModel(GL_SMOOTH);
 
 glLightfv(GL_LIGHT0,GL_SPECULAR,spec);
 glLightfv(GL_LIGHT0,GL_DIFFUSE,diff);
 glLightfv(GL_LIGHT0,GL_AMBIENT,amb);
 
 glEnable(GL_LIGHT0);
 glEnable(GL_LIGHTING);
 
 //glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
 
 GLfloat shinines = 0.0;
 glMaterialfv(GL_FRONT,GL_SHININESS,&shinines);
 
 float colFog[]={0.15*0.4,0.2*0.4,0.5*0.4};
 
 glFogi(GL_FOG_MODE,GL_LINEAR);
 glFogfv(GL_FOG_COLOR,colFog);
 glFogf(GL_FOG_START,4000.0);
 glFogf(GL_FOG_END,5000.0);
 glFogf(GL_FOG_DENSITY,0.1);
 
 glEnable(GL_FOG);
 //===================================
 
 
 //======== Init Terrain =========
 Vecteur p(-(400.0f*40.0f/2.0f),0.0,-90.0);
 trSplt.InitTerrain(p,400,50,40.0,400.0,20.0,1.0/4.0,1.0/4.0,20,19);
 char *textures[]={".\\Media\\MNTTex\\ground.bmp",".\\Media\\MNTTex\\grass.bmp",".\\Media\\MNTTex\\rock.bmp",".\\Media\\MNTTex\\snow.bmp"};
 trSplt.setTexture(CTexture::GetInstance()->getTexture3D("MNTTexture.bmp",4,textures));
 mCld.setTerrain(&trSplt);
 //===============================
 
 //======== Init Cube =========
 cCbox.makeCube(1000.0);
 cCbox.getTexture();
 //============================
 
 //======== Init Prototypes =========
 protoBob.initPrototypes();
 //==================================
 
 //======== Init Joueur =========
 jr.initGraphX();
 jr.setManette(&cMant);
 mCld.addCollide(&jr);
 //==============================
 
 //======== Init Ennemis =========
 Vecteur *ptrP,*ptrV;
 jr.getPtrCible(ptrP,ptrV);
 CItEnnemi::setCiblePosVel(ptrP,ptrV);
 //===============================
 
 //======== Init Explosions =========
 CExplositonAnim::setIdTex(CTexture::GetInstance()->getTexture(".\\Media\\Projectils\\Explosions.bmp",true,255,0,0,0,false));
 //==================================
 
 //======== Init Particules =========
 mdp.initMoteurParticule(3);
 mdp.addNewParticule(".\\Media\\Particules\\QuadLight.bob",CTexture::GetInstance()->getTexture("LIGHT_REDBLUE_TEX_PROC"),1|4,3.0,0.9991);
 mdp.addNewParticule(".\\Media\\Particules\\QuadLight.bob",CTexture::GetInstance()->getTexture("LIGHT_ORANGE_TEX_PROC"),1|4,6.0,0.997);
 mdp.addNewParticule(".\\Media\\Particules\\QuadSmoke.bob",CTexture::GetInstance()->getTexture("SMOKE_TEX_PROC"),1|2,15.0,0.996);
 //==================================
 
 //======== Init Manette =========
 cMant.initManette();
 cMant.setWindowDim(&w,&h);
 cMant.centerMouse();
 cMant.setMouseSensibility(0.00000018,0.00000018);
 //================================
 
 //======== Init Music/Son =========
 id=0;
 o_music.setVolume(LOW_MUSIC_VOLM);
 o_music.launchMusicList(NBZIK,listMusic,true);
 
 o_son.loadSound();
 o_son.initSources(15);
 o_son.setParam(-34.0,1000.0);
 o_son.setVolume(LOW_MUSIC_VOLM);
 //==================================
 
 //======== Init Progression =========
 ennemisPX=0.0;
 progression=500.0;
 stg=START;
 //===================================
}

int CApplication::launch()
{
 if(selfPointer!=this)return 1;
 
 oldTime=glutGet(GLUT_ELAPSED_TIME);
 glutFullScreen();
 glutMainLoop();
 return 0;
}

void CApplication::setMusicId(unsigned char id)
{
     this->id=id;
}
